<?php
require_once __DIR__.'/../init.php';
$q = trim($_GET['q'] ?? '');
$title = 'Search — '.APP_NAME;
include __DIR__.'/partials/header.php';
?>
<h2>Search</h2>
<form>
  <input class="input" type="text" name="q" placeholder="Search news..." value="<?= esc($q) ?>">
</form>
<?php if ($q): 
  $like = '%'.$q.'%';
  $stmt = db()->prepare("SELECT id, title, slug, image, created_at FROM posts WHERE status='published' AND (title LIKE ? OR body LIKE ?) ORDER BY id DESC LIMIT 20");
  $stmt->bind_param('ss', $like, $like);
  $stmt->execute(); $rs = $stmt->get_result();
  ?>
  <h3 style="margin-top:12px">Results</h3>
  <div class="grid">
  <?php while($p = $rs->fetch_assoc()): ?>
    <a class="card" href="post.php?slug=<?= esc($p['slug']) ?>">
      <img src="<?= BASE_URL ?>/public/assets/images/<?= esc($p['image'] ?: 'world1.jpg') ?>" alt="">
      <div class="pad">
        <div class="meta"><span><?= date('M j, Y', strtotime($p['created_at'])) ?></span></div>
        <h3><?= esc($p['title']) ?></h3>
      </div>
    </a>
  <?php endwhile; ?>
  </div>
<?php endif; ?>
<?php include __DIR__.'/partials/footer.php'; ?>