<?php
require_once __DIR__.'/config.php';
session_start();

function db() {
  static $mysqli;
  if (!$mysqli) {
    $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($mysqli->connect_error) {
      die('DB connection failed: ' . $mysqli->connect_error);
    }
    $mysqli->set_charset('utf8mb4');
  }
  return $mysqli;
}

function esc($s) {
  return htmlspecialchars($s ?? '', ENT_QUOTES, 'UTF-8');
}

function is_logged_in() {
  return isset($_SESSION['user_id']);
}

function current_user() {
  if (!is_logged_in()) return null;
  return [
    'id' => $_SESSION['user_id'],
    'name' => $_SESSION['user_name'],
    'email' => $_SESSION['user_email'],
    'role' => $_SESSION['user_role']
  ];
}

function require_login() {
  if (!is_logged_in()) {
    header('Location: '.BASE_URL.'/admin/login.php');
    exit;
  }
}

function require_admin() {
  require_login();
  if (($_SESSION['user_role'] ?? '') !== 'admin') {
    http_response_code(403);
    echo "<h2 style='font-family:system-ui'>Forbidden</h2>";
    exit;
  }
}

function flash($key, $msg=null) {
  if ($msg !== null) {
    $_SESSION['flash_'.$key] = $msg;
  } else {
    $m = $_SESSION['flash_'.$key] ?? '';
    unset($_SESSION['flash_'.$key]);
    return $m;
  }
}

function redirect($path) {
  header("Location: ".BASE_URL.$path);
  exit;
}