<?php
require_once __DIR__.'/../init.php';

$mysqli = db();

function slugify($text) {
  $text = strtolower(preg_replace('~[^\pL\d]+~u', '-', $text));
  $text = trim($text, '-');
  return $text ?: substr(md5(uniqid('', true)), 0, 8);
}

// Admin user
$adminEmail = ADMIN_EMAIL;
$adminPass = ADMIN_PASSWORD;
$adminName = 'Super Admin';

$exists = $mysqli->prepare("SELECT id FROM users WHERE email=?");
$exists->bind_param('s', $adminEmail);
$exists->execute();
$exists->store_result();

if ($exists->num_rows === 0) {
  $hash = password_hash($adminPass, PASSWORD_BCRYPT);
  $stmt = $mysqli->prepare("INSERT INTO users(name, email, password_hash, role) VALUES (?,?,?, 'admin')");
  $stmt->bind_param('sss', $adminName, $adminEmail, $hash);
  $stmt->execute();
  echo "Admin user created: ".$adminEmail." / ". $adminPass ."\n";
} else {
  echo "Admin already exists.\n";
}

// Categories & Subcategories
$cats = [
  'World' => ['Politics', 'Economy', 'Environment'],
  'Technology' => ['Gadgets', 'AI', 'Cybersecurity'],
  'Sports' => ['Cricket', 'Football', 'Tennis'],
  'Entertainment' => ['Movies', 'Music', 'TV Shows']
];

foreach ($cats as $cat => $subs) {
  $cslug = slugify($cat);
  $stmt = $mysqli->prepare("INSERT IGNORE INTO categories(name, slug) VALUES (?,?)");
  $stmt->bind_param('ss', $cat, $cslug);
  $stmt->execute();
  $catId = $mysqli->insert_id;
  if (!$catId) {
    $q = $mysqli->prepare("SELECT id FROM categories WHERE slug=?");
    $q->bind_param('s', $cslug);
    $q->execute(); $res = $q->get_result(); $catId = $res->fetch_assoc()['id'];
  }
  foreach ($subs as $s) {
    $sslug = slugify($s);
    $stmt = $mysqli->prepare("INSERT IGNORE INTO subcategories(category_id, name, slug) VALUES (?,?,?)");
    $stmt->bind_param('iss', $catId, $s, $sslug);
    $stmt->execute();
  }
}

// Pages
$pages = [
  ['about', 'About Us', '<p>We are a modern news organization delivering trusted reporting and insights across World, Technology, Sports, and Entertainment.</p>'],
  ['contact', 'Contact Us', '<p>Email us at support@example.com or call +91-00000-00000.</p>']
];
foreach ($pages as $p) {
  [$slug, $title, $body] = $p;
  $stmt = $mysqli->prepare("INSERT IGNORE INTO pages(slug, title, body) VALUES (?,?,?)");
  $stmt->bind_param('sss', $slug, $title, $body);
  $stmt->execute();
}

// Sample posts (8)
$sample = [
  ['Tech Giants Announce New AI Models', 'Technology', 'AI', 'tech1.jpg'],
  ['Cricket Championship: Thrilling Final', 'Sports', 'Cricket', 'sports1.jpg'],
  ['Global Markets Rally on Optimism', 'World', 'Economy', 'world1.jpg'],
  ['Summer Blockbuster Breaks Records', 'Entertainment', 'Movies', 'ent1.jpg'],
  ['New Gadget Redefines Wearables', 'Technology', 'Gadgets', 'tech2.jpg'],
  ['Historic Climate Accord Reached', 'World', 'Environment', 'world2.jpg'],
  ['Football League: Mid-Season Review', 'Sports', 'Football', 'sports2.jpg'],
  ['Music Awards: Winners & Highlights', 'Entertainment', 'Music', 'ent2.jpg']
];

foreach ($sample as $row) {
  [$title, $catName, $subName, $img] = $row;

  // Get category id
  $c = $mysqli->prepare("SELECT id FROM categories WHERE name=? AND deleted=0");
  $c->bind_param('s', $catName);
  $c->execute(); $catId = ($c->get_result()->fetch_assoc()['id']) ?? null;

  // Get subcategory id
  $s = $mysqli->prepare("SELECT sc.id FROM subcategories sc JOIN categories c ON c.id=sc.category_id WHERE sc.name=? AND c.name=? AND sc.deleted=0 AND c.deleted=0");
  $s->bind_param('ss', $subName, $catName);
  $s->execute(); $subId = ($s->get_result()->fetch_assoc()['id']) ?? null;

  $slug = slugify($title.'-'.uniqid());
  $body = '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean in magna in nisl efficitur posuere. Donec sagittis, ligula ac vestibulum dictum, nibh nibh pharetra nisl, ac hendrerit sapien mauris sit amet nunc.</p>
           <p>Morbi maximus, urna eget pretium vulputate, arcu urna faucibus nisl, sed lobortis tellus justo id mi. Integer at risus id urna interdum fringilla.</p>';
  $stmt = $mysqli->prepare("INSERT IGNORE INTO posts(category_id, subcategory_id, title, slug, image, body, status) VALUES (?,?,?,?,?,?,'published')");
  $stmt->bind_param('iissss', $catId, $subId, $title, $slug, $img, $body);
  $stmt->execute();
}

// Sample pending comments
$q = $mysqli->query("SELECT id FROM posts ORDER BY id DESC LIMIT 3");
while ($r = $q->fetch_assoc()) {
  $pid = (int)$r['id'];
  $stmt = $mysqli->prepare("INSERT INTO comments(post_id, author_name, author_email, body, status) VALUES (?,?,?,?, 'pending')");
  $name = 'Reader '.rand(100,999);
  $email = 'reader'.rand(100,999).'@example.com';
  $body = 'Great read! Looking forward to more updates.';
  $stmt->bind_param('isss', $pid, $name, $email, $body);
  $stmt->execute();
}

echo "\nSeeding complete.\n";