<?php
require_once __DIR__.'/../init.php';
if (is_logged_in()) redirect('/admin/dashboard.php');
$err = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $email = trim($_POST['email'] ?? '');
  $pass  = trim($_POST['password'] ?? '');
  $stmt = db()->prepare("SELECT id, name, email, password_hash, role FROM users WHERE email=?");
  $stmt->bind_param('s', $email);
  $stmt->execute(); $u = $stmt->get_result()->fetch_assoc();
  if ($u && password_verify($pass, $u['password_hash'])) {
    $_SESSION['user_id']=$u['id'];
    $_SESSION['user_name']=$u['name'];
    $_SESSION['user_email']=$u['email'];
    $_SESSION['user_role']=$u['role'];
    redirect('/admin/dashboard.php');
  } else {
    $err = 'Invalid credentials';
  }
}
$title = 'Admin Login — '.APP_NAME;
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= esc($title) ?></title>
<link rel="stylesheet" href="<?= BASE_URL ?>/public/assets/css/style.css">
</head><body>
<div class="container" style="max-width:420px">
  <h2 style="text-align:center;margin:30px 0 10px">Admin Login</h2>
  <?php if ($err): ?><div class="alert"><?= esc($err) ?></div><?php endif; ?>
  <form method="post" class="card" style="padding:16px">
    <p><label>Email</label><br><input class="input" type="email" name="email" required></p>
    <p><label>Password</label><br><input class="input" type="password" name="password" required></p>
    <button class="btn" type="submit" style="width:100%">Sign in</button>
  </form>
</div>
</body></html>