<?php
require_once __DIR__.'/middleware.php';
$title = 'Categories — '.APP_NAME;
$mysqli = db();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  if (isset($_POST['create'])) {
    $name = trim($_POST['name'] ?? '');
    if ($name) {
      $slug = strtolower(preg_replace('/[^a-z0-9]+/i','-', $name));
      $stmt = $mysqli->prepare("INSERT INTO categories(name, slug) VALUES (?,?)");
      $stmt->bind_param('ss', $name, $slug);
      $stmt->execute();
      flash('msg', 'Category added.');
    }
  }
  if (isset($_POST['update'])) {
    $id = (int)$_POST['id']; $name = trim($_POST['name'] ?? '');
    if ($id && $name) {
      $slug = strtolower(preg_replace('/[^a-z0-9]+/i','-', $name));
      $stmt = $mysqli->prepare("UPDATE categories SET name=?, slug=? WHERE id=?");
      $stmt->bind_param('ssi', $name, $slug, $id);
      $stmt->execute();
      flash('msg', 'Category updated.');
    }
  }
  if (isset($_POST['delete'])) {
    $id = (int)$_POST['id'];
    $stmt = $mysqli->prepare("UPDATE categories SET deleted=1 WHERE id=?");
    $stmt->bind_param('i', $id);
    $stmt->execute();
    flash('msg', 'Category moved to trash.');
  }
  if (isset($_POST['restore'])) {
    $id = (int)$_POST['id'];
    $stmt = $mysqli->prepare("UPDATE categories SET deleted=0 WHERE id=?");
    $stmt->bind_param('i', $id);
    $stmt->execute();
    flash('msg', 'Category restored.');
  }
  redirect('/admin/categories.php');
}

$rows = $mysqli->query("SELECT * FROM categories ORDER BY deleted ASC, name ASC");
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= esc($title) ?></title>
<link rel="stylesheet" href="<?= BASE_URL ?>/admin/assets/admin.css">
</head><body><div class="wrap">
  <div class="topbar">
    <h2>Categories</h2>
    <div><a class="badge" href="<?= BASE_URL ?>/admin/dashboard.php">Back</a></div>
  </div>
  <?php if ($m=flash('msg')): ?><div class="alert"><?= esc($m) ?></div><?php endif; ?>
  <form method="post" class="card" style="padding:16px;margin-bottom:16px">
    <div class="form-grid">
      <p><label>Name</label><br><input class="input" name="name" required></p>
    </div>
    <button class="btn" name="create">Add Category</button>
  </form>
  <table class="table">
    <tr><th>ID</th><th>Name</th><th>Slug</th><th>Status</th><th>Actions</th></tr>
    <?php while($r=$rows->fetch_assoc()): ?>
      <tr>
        <td><?= (int)$r['id'] ?></td>
        <td><?= esc($r['name']) ?></td>
        <td><?= esc($r['slug']) ?></td>
        <td><?= $r['deleted'] ? 'Trashed' : 'Active' ?></td>
        <td>
          <form method="post" style="display:inline">
            <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
            <input class="input" name="name" value="<?= esc($r['name']) ?>" style="width:180px">
            <button class="btn secondary" name="update">Update</button>
          </form>
          <?php if (!$r['deleted']): ?>
            <form method="post" style="display:inline"><input type="hidden" name="id" value="<?= (int)$r['id'] ?>"><button class="btn" name="delete">Trash</button></form>
          <?php else: ?>
            <form method="post" style="display:inline"><input type="hidden" name="id" value="<?= (int)$r['id'] ?>"><button class="btn" name="restore">Restore</button></form>
          <?php endif; ?>
        </td>
      </tr>
    <?php endwhile; ?>
  </table>
</div></body></html>