# News Portal Using PHP & MySQL

A clean, production-style starter with **frontend (user)** and **backend (admin/sub-admin)** modules.
Built for XAMPP (PHP 7.x, MySQL 5.x). No `.env` used—configuration lives in `config.php`.

## Features
- Professional landing page with hero, categories, and latest news
- Category & Subcategory browsing
- Post pages with related posts
- Search
- About Us & Contact Us editable pages
- Reader comments (pending approval)
- Admin login (role: admin, sub-admin)
- Admin dashboard with counts
- CRUD for Categories, Subcategories, Posts (with Trash/Restore)
- Manage Pages (About, Contact)
- Manage Comments (approve / unapprove / delete)
- Manage Sub-Admins (admin only)
- Seeder to create admin and sample data: `database/seed.php`

## Requirements
- PHP 7.x
- MySQL 5.x
- XAMPP (Apache, MySQL)
- Browser: Chrome/Firefox/Edge/Opera

## Quick Start (XAMPP)
1. Copy the `news-portal` folder into `htdocs` (e.g., `C:\xampp\htdocs\news-portal`).
2. Start Apache & MySQL (XAMPP Control Panel).
3. Create a database named `news_portal`.
4. Import `database/schema.sql` into `news_portal` (via phpMyAdmin).
5. Open `http://localhost/news-portal/database/seed.php` once to insert:
   - Admin user: **ADMIN_EMAIL** / **ADMIN_PASSWORD**
   - Sample categories, posts, pages, and comments
6. Visit frontend: `http://localhost/news-portal/public/`
7. Visit admin: `http://localhost/news-portal/admin/login.php`

> Default credentials (also in `config.php`):
> - Email: `admin@example.com`
> - Password: `Admin@123`

> Change DB credentials and admin credentials in `config.php` as needed.

## Project Structure
```
news-portal/
  admin/
  database/
  lib/
  public/
  uploads/
  config.php
  init.php
  README.md
```