<?php
require_once __DIR__.'/middleware.php';
$title = 'Dashboard — '.APP_NAME;
$mysqli = db();

$counts = [
  'categories' => $mysqli->query("SELECT COUNT(*) c FROM categories WHERE deleted=0")->fetch_assoc()['c'],
  'subcategories' => $mysqli->query("SELECT COUNT(*) c FROM subcategories WHERE deleted=0")->fetch_assoc()['c'],
  'posts' => $mysqli->query("SELECT COUNT(*) c FROM posts WHERE status='published'")->fetch_assoc()['c'],
  'trash' => $mysqli->query("SELECT COUNT(*) c FROM posts WHERE status='trashed'")->fetch_assoc()['c'],
  'pending_comments' => $mysqli->query("SELECT COUNT(*) c FROM comments WHERE status='pending'")->fetch_assoc()['c']
];
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= esc($title) ?></title>
<link rel="stylesheet" href="<?= BASE_URL ?>/admin/assets/admin.css">
</head><body>
<div class="wrap">
  <div class="topbar">
    <div><strong><?= esc(APP_NAME) ?></strong> — Admin</div>
    <div class="actions">
      <a class="badge" href="<?= BASE_URL ?>/admin/categories.php">Categories</a>
      <a class="badge" href="<?= BASE_URL ?>/admin/subcategories.php">Subcategories</a>
      <a class="badge" href="<?= BASE_URL ?>/admin/posts.php">Posts</a>
      <a class="badge" href="<?= BASE_URL ?>/admin/comments.php">Comments</a>
      <a class="badge" href="<?= BASE_URL ?>/admin/pages.php">Pages</a>
      <?php if (($_SESSION['user_role'] ?? '')==='admin'): ?>
        <a class="badge" href="<?= BASE_URL ?>/admin/subadmins.php">Sub-Admins</a>
      <?php endif; ?>
      <a class="badge" href="<?= BASE_URL ?>/admin/logout.php">Logout</a>
    </div>
  </div>

  <div class="grid">
    <div class="stat"><h4>Categories</h4><div><?= (int)$counts['categories'] ?></div></div>
    <div class="stat"><h4>Subcategories</h4><div><?= (int)$counts['subcategories'] ?></div></div>
    <div class="stat"><h4>Published Posts</h4><div><?= (int)$counts['posts'] ?></div></div>
    <div class="stat"><h4>Trash</h4><div><?= (int)$counts['trash'] ?></div></div>
    <div class="stat"><h4>Pending Comments</h4><div><?= (int)$counts['pending_comments'] ?></div></div>
  </div>
</div>
</body></html>