<?php
require_once __DIR__.'/middleware.php';
$title = 'Comments — '.APP_NAME;
$mysqli = db();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $id=(int)($_POST['id'] ?? 0);
  if (isset($_POST['approve'])) { $stmt=$mysqli->prepare("UPDATE comments SET status='approved' WHERE id=?"); $stmt->bind_param('i',$id); $stmt->execute(); }
  if (isset($_POST['unapprove'])) { $stmt=$mysqli->prepare("UPDATE comments SET status='pending' WHERE id=?"); $stmt->bind_param('i',$id); $stmt->execute(); }
  if (isset($_POST['delete'])) { $stmt=$mysqli->prepare("DELETE FROM comments WHERE id=?"); $stmt->bind_param('i',$id); $stmt->execute(); }
  flash('msg','Updated.'); redirect('/admin/comments.php');
}

$rows = $mysqli->query("SELECT cm.*, p.title post_title FROM comments cm JOIN posts p ON p.id=cm.post_id ORDER BY cm.id DESC");
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= esc($title) ?></title>
<link rel="stylesheet" href="<?= BASE_URL ?>/admin/assets/admin.css">
</head><body><div class="wrap">
  <div class="topbar"><h2>Comments</h2><div><a class="badge" href="<?= BASE_URL ?>/admin/dashboard.php">Back</a></div></div>
  <?php if ($m=flash('msg')): ?><div class="alert"><?= esc($m) ?></div><?php endif; ?>
  <table class="table">
    <tr><th>ID</th><th>Post</th><th>Author</th><th>Email</th><th>Body</th><th>Status</th><th>Actions</th></tr>
    <?php while($r=$rows->fetch_assoc()): ?>
      <tr>
        <td><?= (int)$r['id'] ?></td>
        <td><?= esc($r['post_title']) ?></td>
        <td><?= esc($r['author_name']) ?></td>
        <td><?= esc($r['author_email']) ?></td>
        <td><?= esc($r['body']) ?></td>
        <td><?= esc($r['status']) ?></td>
        <td>
          <form method="post" style="display:inline"><input type="hidden" name="id" value="<?= (int)$r['id'] ?>"><?php if ($r['status']==='pending'): ?><button class="btn" name="approve">Approve</button><?php else: ?><button class="btn secondary" name="unapprove">Unapprove</button><?php endif; ?></form>
          <form method="post" style="display:inline"><input type="hidden" name="id" value="<?= (int)$r['id'] ?>"><button class="btn" name="delete">Delete</button></form>
        </td>
      </tr>
    <?php endwhile; ?>
  </table>
</div></body></html>